## Plotting Functions for Daily Download and Annual Maxima

library(RColorBrewer)
library(Hmisc)

## Daily Discharge Plot
Daily_Plot <- function(all_site, thresholds) {
	for (i in 1:(length(all_site))){
		ofile <- names(all_site)
		png(file = file.path(iPath_Image,paste0(ofile[i],"Daily",".png")), width = 1600, height = 800)
		
		par(mar = c(6,6,5,5))
		plot(all_site[[i]]$Date, all_site[[i]]$Discharge, type = 'l', lwd = 1.95,col = "red",
		main = paste(ofile[i], "Daily Mean Discharge"),log = "y", ylim = c(min(all_site[[i]]$Discharge), 1.2*(max(all_site[[i]]$Discharge))),
		xlab ="Time (YYYY-MM-DD)", ylab = "Log Discharge (Cubic Feet per Second)", cex.axis = 1.25, cex.lab = 1.5, cex.main = 1.75)
		
		abline(h = thresholds[i,1], col = "blue", lwd = 2)

		points(all_site[[i]]$Date[all_site[[i]]$POT],all_site[[i]]$Discharge[all_site[[i]]$POT], 
		pch = 16, col = "black", cex = 2)

		legend("topleft", c("Peaks Over Threshold", "Q2 Threshold", "Daily Mean Discharge"), pch = c(16,NA,NA),
		lwd = 2, lty = c(NA,1,1), col = c("black","blue","red"), ncol = 1, cex = 1.15)

		dev.off()
	}
}

###################################################################################

## Annual Peak Streamflow Plot
Annual_Plot <- function(all_site, thresholds) {
	for (i in 1:(length(all_site))){
		ofile <- names(all_site)
		png(file = file.path(iPath_Image,paste0(ofile[i],"Annual",".png")), width = 1600, height = 800)
		
		par(mar = c(6,6,5,5))
		plot(all_site[[i]]$WaterYR, all_site[[i]]$Discharge, ylim = c(min(all_site[[i]]$Discharge),1.1*(max(all_site[[i]]$Discharge))),
		pch = 19,col = "darkgreen", main = paste(ofile[i], "Peak Streamflow"), xlab ="Year", 
		ylab = "Discharge (CFS)", xaxt = 'n', cex = 2.5,cex.axis = 1.25, cex.lab = 1.5, cex.main = 1.75)

		axis(1, at = seq((min(all_site[[i]]$WaterYR)), (max(all_site[[i]]$WaterYR)), 8), cex.axis = 1.25)
				
		abline(h = thresholds [i,1], col = "blue", lwd = 2.5)
		
		legend("topleft",c("Annual Maxima","Q2 Threshold"), lwd = 2, pch = c(19, NA), lty=c(NA, 1), 
		col = c("darkgreen","blue"), ncol=1, cex = 1.35) 
		dev.off()
	}
}

###################################################################################

## Daily Mean Overlay Plot

Overlay_Plot <- function(sites) {
	color <- brewer.pal(n = nrow(sites), name = "Dark2")
	limit_max <- NULL
	limit_min <- NULL
	
	for (i in 1:(length(all_site))){
	  	limit_max[i] <- max(all_site[[i]]$Discharge)
		  limit_min[i] <- min(all_site[[i]]$Discharge)
	}

	png(file = file.path(iPath_Image,paste0("Daily Discharge All Sites (HUC8:10160003)",".png")), width = 1600, height = 800)
	par(mar = c(6,6,5,5))
	plot(all_site[[1]]$Date, all_site[[1]]$Discharge, type = 'l', lwd = 1.25,col = color[1] ,
	main = "Daily Mean Discharge (All Sites)",log = "y", ylim = c(min(limit_min),(1.15*max(limit_max))), 
	xlab ="Time (YYYY-MM-DD)", ylab = " Discharge (Cubic Meter per Second)", cex.axis = 1.25, cex.lab = 1.5, cex.main = 1.75)
	
	for (j in 2:(length(all_site))){
		  lines(all_site[[j]]$Date, all_site[[j]]$Discharge, col = color[j], type = 'l', lwd = 1.25)	
	}
	
	
	legend("topleft", legend = c("06470000", "06470500", "06470800", "06470878", "06471000", "06472000"), col = color, lty = 1, lwd = 3, 
	cex = 1.15, ncol = 2, title = "Site Name : Site ID", bty = 'n',xpd = TRUE)
	
	dev.off()
}

